<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns="http://www.w3.org/1999/xhtml">

<xsl:output
	method="html"
	encoding="UTF-16"
	doctype-public="-//W3C//DTD XHTML 1.1//EN"
	doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"
	indent="yes"
	cdata-section-elements="style script"/>

<xsl:template match="/root">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-16" />
		<link rel="stylesheet" href="../css/common.css" media="screen,print" charset="utf-8" type="text/css" />

		<script type="text/javascript" src="../js/jquery.js" charset="utf-8"></script>
	</head>
	<body id="transactionDetail">
		<div id="content">
			<xsl:for-each select="header/section">
				<div class="{@style}">
					<xsl:for-each select="line">
						<xsl:value-of select="@title"/><xsl:value-of select="@string"/><br/>
					</xsl:for-each>
				</div>
			</xsl:for-each>
            
            <div id="topBalanceHeader">
                <xsl:for-each select="topBalances/topBalance">
                    <div class="balanceContent">
                        <xsl:value-of select="@title"/><xsl:value-of select="@amount"/>
                    </div>
                </xsl:for-each>
            </div>
			<div id="contentBody">
				<table class="transactionDetail">
					<thead><tr>
						<xsl:for-each select="columns/column">
							<xsl:variable name="index" select="position()"/>
							<th style="width: {@widthPercentage}%; text-align: {@alignment}; white-space: nowrap"><xsl:value-of select="@title"/></th>
						</xsl:for-each>
					</tr></thead>
					<tbody>
						<xsl:for-each select="transactions/transaction">
							<tr>
								<xsl:for-each select="*">
									<xsl:variable name="index" select="position()"/>
									<td style="text-align: {../../../columns/column[$index]/@alignment}; white-space: {../../../columns/column[$index]/@whiteSpace}"><xsl:value-of select="."/></td>
								</xsl:for-each>
							</tr>
						</xsl:for-each>
					</tbody>
				</table>
<!--				<xsl:apply-templates select="transactions"/>-->
			</div>
            
            <div id="bottomBalanceHeader">
                <xsl:for-each select="bottomBalances/bottomBalance">
                    <div class="balanceContent">
                        <xsl:value-of select="@title"/><xsl:value-of select="@amount"/>
                    </div>
                </xsl:for-each>
            </div>

			<div id="summary">
				<xsl:for-each select="totals/total">
					<div class="header">
						<xsl:value-of select="@title"/><xsl:value-of select="@amount"/>
					</div>
				</xsl:for-each>
			</div>
		</div>
	</body>
	</html>
</xsl:template>


<!--<xsl:template match="transactions">
	<table class="transactionDetail">
		<thead><tr>
			<th class='dateHeader'>Date</th>
			<th class='checkNumberHeader'>Number</th>
			<th class='payeeHeader'>Payee</th>
			<th class='tagsHeader'>Tags</th>
			<th class='amountHeader currency'>Amount</th>
			<th class='balance currency'>Balance</th>
		</tr></thead>
		
		<tbody>
			<xsl:apply-templates select="transaction"/>
		</tbody>
	</table>
</xsl:template>


<xsl:template match="transaction">
	<tr id="transaction_{@quickenID}">
		<td class="date"><xsl:value-of select="date"/></td>
		<td class="checkNumber"><xsl:value-of select="checkNumber"/></td>
		<td class="payee"><xsl:value-of select="payee"/></td>
		<td class="tags">
			<ul class="userTags">
				<xsl:apply-templates select="userTag"/>
				<xsl:apply-templates select="categoryTag"/>
			</ul>
		</td>
		
		<xsl:choose>
			<xsl:when  test="amount[@sign='negative']">
				<td class="amount negative"><xsl:value-of select="amount"/></td>
			</xsl:when>
			<xsl:otherwise>
				<td class="amount"><xsl:value-of select="amount"/></td>
			</xsl:otherwise>
		</xsl:choose>
		
		<xsl:choose>
			<xsl:when  test="balance[@sign='negative']">
				<td class="balance negative"><xsl:value-of select="balance"/></td>
			</xsl:when>
			<xsl:otherwise>
				<td class="balance"><xsl:value-of select="balance"/></td>
			</xsl:otherwise>
		</xsl:choose>
	</tr>
</xsl:template>


<xsl:template match="userTag">
	<li><xsl:value-of select="."/></li>
</xsl:template>


<xsl:template match="categoryTag">
	<li><xsl:value-of select="."/></li>
</xsl:template>-->

</xsl:stylesheet>
